<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Maintenance extends Model 
{

    protected $table = 'maintenances';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client()
    {
        return $this->belongsTo('Client');
    }

    public function mechanic()
    {
        return $this->belongsTo('Mechanic');
    }

    public function service()
    {
        return $this->belongsTo('Service');
    }

    public function bicycle()
    {
        return $this->belongsTo('Bicycle');
    }

}