<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'event';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');
    protected $visible = array('name', 'description');

    public function has_venue()
    {
        return $this->belongsTo('Venue');
    }

    public function has_ticketclass()
    {
        return $this->hasMany('TicketClass');
    }

}