<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone', 191);
			$table->integer('city_id');
			$table->date('date_of_birth');
			$table->boolean('gender');
			$table->string('old_file', 191);
			$table->string('name', 191);
			$table->integer('clinic_id');
			$table->string('email', 191);
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}