<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model 
{

    protected $table = 'campaigns';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('winner_id', 'timestamps', 'active');

    public function destinations()
    {
        return $this->hasMany('Destination', 'campaign_id');
    }

    public function winner()
    {
        return $this->hasOne('Entry', 'campaign_id');
    }

    public function entries()
    {
        return $this->hasMany('Entry', 'campaign_id');
    }

}