<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirportsTable extends Migration {

	public function up()
	{
		Schema::create('airports', function(Blueprint $table) {
			$table->increments('id');
			$table->string('iata', 3)->unique();
			$table->string('name', 128);
			$table->string('area', 128);
			$table->string('city', 128)->nullable();
			$table->boolean('partner');
			$table->string('map_bounds', 250);
		});
	}

	public function down()
	{
		Schema::drop('airports');
	}
}