<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Campaign extends Eloquent {

	protected $table = 'campaigns';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('winner_id', 'timestamps', 'active');

	public function destinations()
	{
		return $this->hasMany('Destination', 'campaign_id');
	}

	public function winner()
	{
		return $this->hasOne('Entry', 'campaign_id');
	}

	public function entries()
	{
		return $this->hasMany('Entry', 'campaign_id');
	}

}