<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Destination extends Eloquent {

	protected $table = 'destinations';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('campaign_id', 'airport_departure_id', 'airport_destination_id');

	public function entries()
	{
		return $this->hasMany('Entry', 'destination_id');
	}

	public function campaign()
	{
		return $this->belongsTo('Campaign');
	}

	public function locations()
	{
		return $this->hasMany('Location');
	}

	public function destination()
	{
		return $this->hasOne('Airport', 'id', 'airport_destination_id');
	}

	public function departure()
	{
		return $this->hasOne('Airport', 'id', 'airport_departure_id');
	}

}