<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->json('name');
			$table->integer('position');
			$table->string('Image');
			$table->json('meta_title');
			$table->json('meta_description');
			$table->json('slug');
			$table->json('meta_keywords');
			$table->integer('vendor_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}