<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMrComplianceTable extends Migration {

	public function up()
	{
		Schema::create('mr_compliance', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('current_payable_renumeration', 15,2);
			$table->datetime('renumeration_year_ending_date');
			$table->string('aggrement_document_lists');
			$table->string('prescribe_period');
			$table->string('restriction_area');
			$table->string('details');
			$table->datetime('completion_date');
			$table->string('completion_place');
			$table->string('lender_company');
			$table->datetime('approval_date');
			$table->decimal('loan_amount', 15,2);
			$table->datetime('contract_date');
			$table->string('seller_name');
			$table->string('buyer_name');
			$table->string('unit_description');
			$table->string('prior_to_completion');
			$table->string('after_completion');
		});
	}

	public function down()
	{
		Schema::drop('mr_compliance');
	}
}