<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('item', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoice')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('item')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('profile', function(Blueprint $table) {
			$table->dropForeign('profile_user_id_foreign');
		});
		Schema::table('bank', function(Blueprint $table) {
			$table->dropForeign('bank_user_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_user_id_foreign');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->dropForeign('client_user_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_client_id_foreign');
		});
		Schema::table('item', function(Blueprint $table) {
			$table->dropForeign('item_category_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_user_id_foreign');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->dropForeign('invoice_items_invoice_id_foreign');
		});
		Schema::table('invoice_items', function(Blueprint $table) {
			$table->dropForeign('invoice_items_product_id_foreign');
		});
	}
}