<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone');
			$table->string('name');
			$table->date('date')->index();
			$table->time('time')->index();
			$table->integer('count')->default('1');
			$table->string('stop');
			$table->string('info');
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}