<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('routetimes', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stops', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('routetimes', function(Blueprint $table) {
			$table->dropForeign('routetimes_route_id_foreign');
		});
		Schema::table('stops', function(Blueprint $table) {
			$table->dropForeign('stops_route_id_foreign');
		});
	}
}