<?php

namespace App/CaseNotification;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CaseNotification extends Eloquent {

	protected $table = 'case_notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'message', 'delivery_method', 'recipient', 'sent_at', 'case_id');

	public function case()
	{
		return $this->belongsTo('Case');
	}

}