<?php

namespace Category;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'Category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restaurant()
    {
        return $this->belongsTo('Restaurant');
    }

    public function meals()
    {
        return $this->hasMany('Meal');
    }

}