<?php

namespace Employee;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'Employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restaurant()
    {
        return $this->belongsTo('Restaurant');
    }

    public function devices()
    {
        return $this->hasMany('Device');
    }

}