<?php

namespace Restaurant;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Restaurant extends Model 
{

    protected $table = 'Restaurant';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function clients()
    {
        return $this->belongsToMany('User\User');
    }

    public function devices()
    {
        return $this->hasMany('Device\Device');
    }

    public function categories()
    {
        return $this->hasMany('Category');
    }

    public function employees()
    {
        return $this->hasMany('Employee');
    }

}