<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Usuario extends Model 
{

    protected $table = 'usuarios';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ciudad()
    {
        return $this->hasOne('Localidad');
    }

    public function permisos()
    {
        return $this->belongsToMany('Permiso', 'permisos_usuarios', 'id_usuario', 'id_permiso');
    }

}