<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Usuario extends Eloquent {

	protected $table = 'usuarios';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ciudad()
	{
		return $this->hasOne('Localidad');
	}

	public function permisos()
	{
		return $this->belongsToMany('Permiso', 'permisos_usuarios', 'id_usuario', 'id_permiso');
	}

}