<?php

namespace App\Models;

class Trip extends Eloquent {

	protected $table = 'trips';
	public $timestamps = true;
	protected $fillable = array('from_address', 'from_lng', 'to_address', 'to_lat', 'to_lng', 'status', 'cancel_text', 'total_distance', 'trip_duration', 'trip_salary', 'tax', 'total_salary', 'car_id', 'cient_id', 'promocode_id');

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function car()
	{
		return $this->belongsTo('App\Models\Car');
	}

	public function promocode()
	{
		return $this->belongsTo('App\Models\Promocode');
	}

}