<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('amount')->default('0');
			$table->enum('status', array('panding', 'approved', 'successfull', 'rejected', 'initiated'));
			$table->integer('user_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}