<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'user_id', 'order_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

}