<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subscription extends Eloquent {

	protected $table = 'subscriptions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'service_id', 'start_date', 'end_date');

	public function user()
	{
		return $this->belongsTo('\User', 'user_id');
	}

	public function service_id()
	{
		return $this->belongsTo('\Service', 'service_id');
	}

}