<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tenant_user', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tenant_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_user_id_foreign');
		});
		Schema::table('tenant_user', function(Blueprint $table) {
			$table->dropForeign('tenant_user_tenant_id_foreign');
		});
		Schema::table('tenant_user', function(Blueprint $table) {
			$table->dropForeign('tenant_user_user_id_foreign');
		});
	}
}