<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('branch_categories', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('branch_id')->unsigned()->index();
			$table->bigInteger('category_id')->unsigned()->index();
			$table->boolean('status')->default(true);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branch_categories');
	}
}