<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchStockProductsTable extends Migration {

	public function up()
	{
		Schema::create('branch_stock_products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned()->index();
			$table->bigInteger('size_id')->unsigned()->nullable()->index();
			$table->bigInteger('color_id')->unsigned()->nullable()->index();
			$table->decimal('quantity')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branch_stock_products');
	}
}