<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashiersTable extends Migration {

	public function up()
	{
		Schema::create('cashiers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('branch_id')->unsigned()->index();
			$table->string('name', 32)->nullable();
			$table->integer('code')->unique();
			$table->string('password');
			$table->boolean('status')->default(true);
			$table->string('activation_code')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cashiers');
	}
}