<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ColorProduct extends Eloquent {

	protected $table = 'color_product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function picture()
	{
		return $this->hasMany('ProductPicture');
	}

	public function color()
	{
		return $this->belongsTo('Color');
	}

}