<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductPrice extends Eloquent {

	protected $table = 'product_prices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('Product');
	}

	public function productSize()
	{
		return $this->belongsTo('ProductSize');
	}

	public function colorProduct()
	{
		return $this->belongsTo('ColorProduct');
	}

}