<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DonationRequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;

    public function bloodType()
    {
        return $this->belongsTo('\BloodType');
    }

    public function governorate()
    {
        return $this->belongsTo('\Governorate');
    }

    public function clients()
    {
        return $this->belongsToMany('\Client')->withPivot('readed','title','content');
    }

}