<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Booking extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->hasOne('App\Models\Status', 'id');
	}

	public function phone()
	{
		return $this->hasOne('App\Models\Phone', 'id');
	}

	public function photos()
	{
		return $this->hasMany('App\Models\BookingPhoto', 'booking_id');
	}

	public function technician()
	{
		return $this->hasOne('App\Models\Technician', 'id');
	}

}