<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttendanceCleanTable extends Migration {

	public function up()
	{
		Schema::create('attendance_clean', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('attendance_id')->nullable();
			$table->integer('file_id')->nullable();
			$table->integer('pernr')->nullable();
			$table->string('personnel_area')->nullable();
			$table->string('personnel_subarea')->nullable();
			$table->string('org_unit')->nullable();
			$table->date('date')->nullable();
			$table->time('time')->nullable();
			$table->integer('type')->nullable();
			$table->boolean('status_sent')->nullable();
			$table->date('sent_date')->nullable();
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->text('message')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attendance_clean');
	}
}