<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('categories')->unsigned();
			$table->string('anchor', 100);
			$table->string('title', 100);
			$table->string('subtitle', 500);
			$table->string('url', 500);
			$table->datetime('enable_date');
			$table->datetime('disable_date');
			$table->integer('duration')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}