<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('subtitle');
			$table->string('description');
			$table->string('image');
			$table->integer('duration_day');
			$table->integer('price_base');
			$table->integer('discount');
			$table->string('time_discount');
			$table->integer('commission');
			$table->enum('status', array('active', 'inactive'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}