<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sitemap_id')->unsigned()->index();
			$table->integer('category_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('_lft');
			$table->integer('_rgt');
			$table->integer('_dpt');
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}