<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('languages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->string('name');
			$table->string('alphabet');
			$table->string('native');
			$table->string('regional');
			$table->string('flag');
			$table->enum('direction', array('ltr', 'rtl'));
			$table->enum('active', array('0', '1'));
			$table->enum('default', array('0', '1'));
			$table->integer('sort')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('languages');
	}
}