<?php

namespace Mediapress/Core/Models;

class CategoryDetail extends Eloquent {

	protected $table = 'category_details';
	public $timestamps = false;
	protected $fillable = array('name', 'slug', 'detail');

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function extras()
	{
		return $this->morphMany('Extra', 'model');
	}

	public function url()
	{
		return $this->morphOne('Url', 'model')->where('type','original');
	}

}