<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('sitemap_id', 'category_id', '_lft', '_rgt', '_dpt');

    public function sitemap()
    {
        return $this->belongsTo('Sitemap');
    }

    public function details()
    {
        return $this->hasMany('CategoryDetail');
    }

}