<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSimulationProductTable extends Migration {

	public function up()
	{
		Schema::create('simulation_product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('simulation_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('quantity')->default('1');
			$table->decimal('price');
			$table->integer('discount')->nullable();
			$table->decimal('final_price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('simulation_product');
	}
}