<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_price', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_price', function(Blueprint $table) {
			$table->foreign('reseller_id')->references('id')->on('resellers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('simulations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('simulation_product', function(Blueprint $table) {
			$table->foreign('simulation_id')->references('id')->on('simulations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('simulation_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('simulation_id')->references('id')->on('simulations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('product_price', function(Blueprint $table) {
			$table->dropForeign('product_price_product_id_foreign');
		});
		Schema::table('product_price', function(Blueprint $table) {
			$table->dropForeign('product_price_reseller_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_product_id_foreign');
		});
		Schema::table('product_category', function(Blueprint $table) {
			$table->dropForeign('product_category_category_id_foreign');
		});
		Schema::table('simulations', function(Blueprint $table) {
			$table->dropForeign('simulations_category_id_foreign');
		});
		Schema::table('simulation_product', function(Blueprint $table) {
			$table->dropForeign('simulation_product_simulation_id_foreign');
		});
		Schema::table('simulation_product', function(Blueprint $table) {
			$table->dropForeign('simulation_product_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_simulation_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_order_id_foreign');
		});
	}
}