<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('name', 191);
			$table->text('logo');
			$table->bigInteger('phone');
			$table->string('website', 191);
			$table->text('description');
			$table->tinyInteger('status');
			$table->text('address');
			$table->decimal('lat', 10,8);
			$table->decimal('lng', 11,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}