<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('business_id')->unsigned();
			$table->string('name');
			$table->string('email')->nullable();
			$table->string('phone_number');
			$table->string('description');
			$table->string('area');
			$table->string('city');
			$table->integer('state_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->string('average_delivery_time_rating')->nullable();
			$table->integer('local_government_id')->unsigned();
			$table->string('average_quality_rating')->nullable();
			$table->string('average_customer_satisfaction_rating')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}