<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lesson_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_user', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapter', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapter')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapter_question', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapter')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapter_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('lesson_user', function(Blueprint $table) {
			$table->dropForeign('lesson_user_user_id_foreign');
		});
		Schema::table('lesson_user', function(Blueprint $table) {
			$table->dropForeign('lesson_user_lesson_id_foreign');
		});
		Schema::table('chapter', function(Blueprint $table) {
			$table->dropForeign('chapter_lesson_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_chapter_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_lesson_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('chapter_question', function(Blueprint $table) {
			$table->dropForeign('chapter_question_chapter_id_foreign');
		});
		Schema::table('chapter_question', function(Blueprint $table) {
			$table->dropForeign('chapter_question_question_id_foreign');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->dropForeign('question_quiz_question_id_foreign');
		});
		Schema::table('question_quiz', function(Blueprint $table) {
			$table->dropForeign('question_quiz_quiz_id_foreign');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->dropForeign('question_quiz_user_quiz_id_foreign');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->dropForeign('question_quiz_user_question_id_foreign');
		});
		Schema::table('question_quiz_user', function(Blueprint $table) {
			$table->dropForeign('question_quiz_user_user_id_foreign');
		});
	}
}