<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRetraitsTable extends Migration {

	public function up()
	{
		Schema::create('retraits', function(Blueprint $table) {
			$table->integer('id_client')->unsigned();
			$table->integer('id_createur')->unsigned();
			$table->integer('id_agence')->unsigned()->nullable();
			$table->softDeletes();
			$table->integer('montant');
			$table->boolean('etat')->default(0);
			$table->timestamps();
			$table->increments('id');
			$table->string('slug', 255);
		});
	}

	public function down()
	{
		Schema::drop('retraits');
	}
}