<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255);
			$table->integer('id_createur')->unsigned();
			$table->integer('id_agence')->unsigned()->nullable();
			$table->integer('id_plan')->unsigned();
			$table->integer('dureeProjet')->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('prenom', 255)->nullable();
			$table->string('sexe', 255)->default('0');
			$table->date('date_naissance')->nullable();
			$table->string('photoVersoCNI', 255)->nullable();
			$table->string('photoPasseport', 255)->nullable();
			$table->string('photoRectoCNI', 255)->nullable();
			$table->boolean('etat')->default(0);
			$table->string('statutConfirmation', 255)->default('0');
			$table->integer('solde')->default('0');
			$table->timestamps();
			$table->softDeletes();
			$table->string('photo', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}