<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsorrysTable extends Migration {

	public function up()
	{
		Schema::create('clientsorrys', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255);
			$table->integer('id_createur')->unsigned()->nullable();
			$table->integer('id_plan')->unsigned()->nullable();
			$table->integer('id_agence')->unsigned()->nullable();
			$table->integer('id_client')->unsigned()->nullable();
			$table->integer('dureeProjet')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom', 255)->nullable();
			$table->string('prenom', 255)->nullable();
			$table->char('sexe', 255)->nullable()->default('0');
			$table->date('date_naissance')->nullable();
			$table->string('photoVersoCNI', 255)->nullable();
			$table->string('photoPasseport', 255)->nullable();
			$table->string('photoRectoCNI', 255)->nullable();
			$table->boolean('etat')->nullable()->default(0);
			$table->integer('solde')->default('0');
			$table->string('motif', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clientsorrys');
	}
}