<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParametresTable extends Migration {

	public function up()
	{
		Schema::create('parametres', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_plan')->unsigned();
			$table->string('slug', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('pourcentageInteret');
			$table->integer('moisMin')->nullable();
			$table->integer('moisMax')->nullable();
			$table->boolean('etat')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('parametres');
	}
}