<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupportThreadsTable extends Migration {

	public function up()
	{
		Schema::create('support_threads', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('support_id')->unsigned();
			$table->bigInteger('sender_id')->unsigned();
			$table->bigInteger('receiver_id')->unsigned();
			$table->text('body')->nullable();
			$table->text('attachment');
		});
	}

	public function down()
	{
		Schema::drop('support_threads');
	}
}