<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->string('name_en')->nullable();
			$table->string('name_th');
			$table->integer('size')->unsigned();
			$table->string('mime');
			$table->text('path');
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}