<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Image extends Eloquent {

	protected $table = 'images';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('parrent', 'title', 'description', 'width', 'height');
	protected $visible = array('parrent', 'title', 'description', 'width', 'height');

	public function attachments()
	{
		return $this->belongsTo('Attachment', 'attachment_id');
	}

	public function products()
	{
		return $this->belongsTo('Product', 'product_id');
	}

}