<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'cart_id', 'user_address_id', 'payment_type_id', 'total', 'discount', 'discount_code', 'earn_reward_point', 'use_reward_point');
	protected $visible = array('user_id', 'cart_id', 'user_address_id', 'payment_type_id', 'total', 'discount', 'discount_code', 'earn_reward_point', 'use_reward_point');

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function cart()
	{
		return $this->hasMany('Cart', 'cart_id');
	}

	public function userRewardPoints()
	{
		return $this->hasMany('UserRewardPoint', 'order_id');
	}

	public function paymentType()
	{
		return $this->belongsTo('PaymentType', 'payment_type_id');
	}

}